-- Name: BSU_addHeightTypes
-- Author: Chissel

BSU_addHeightTypes = {}

local modDirectory = g_currentModDirectory

function BSU_addHeightTypes:loadMapData(xmlFile, missionInfo, baseDirectory)
    local heightTypesXML = loadXMLFile("BSU_heightTypes", modDirectory.."xml/BSU_heightTypes.xml")
    g_densityMapHeightManager:loadDensityMapHeightTypes(heightTypesXML, missionInfo, modDirectory, false)

    BSU_bunkerSiloOverwrites.availableFillTypes = BSU_addHeightTypes.getAllTrapTypes(g_densityMapHeightManager.heightTypes)
end

function BSU_addHeightTypes.getAllTrapTypes(heightTypes)
    local allTarpFillTypes = {}

    for k, heightType in ipairs(heightTypes) do
        if string.find(heightType.fillTypeName, "TARP") then
            table.insert(allTarpFillTypes, heightType.fillTypeIndex)
        end
    end

    return allTarpFillTypes
end