--[[
Script to allow free rotation and placement of all placeable.

Author:  Iceflower S
Version: 22.2022.2.9

History:
22.2022.2.9
    - initial release in FS 22

License (MIT):
Copyright 2022 Iceflower S

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
]]

FreePlacement = {}
FreePlacement.placeablePlacementOnLoad = PlaceablePlacement.onLoad

function onLoadFreePlacement(self, savegame)
    FreePlacement.placeablePlacementOnLoad(self, savegame)
    self.spec_placement.positionSnapSize = 0.0
    self.spec_placement.positionSnapOffset = 0.0
    self.spec_placement.rotationSnapAngle = 0.0
end

PlaceablePlacement.onLoad = onLoadFreePlacement
